/********************************************************************************
* (c) Copyright 2005, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
************************************************************************************/
#ifndef _TOOLBOX_H_
#define _TOOLBOX_H_

/* Place NR before a function if the return value
   from the function is not used - avoids using a
   pragma to switch of compiler warnings. */
#define NR (void)


/* Exists in the MAC library, but we can also use them in the application */
void FLib_MemCpy(void *, void *, uint8_t);

/* Almost ANSI compliant versions of memcpy/memcmp 
   Length (l) can only be in the range 0-255 
   memcmp returns 0 if x==y and 1 if x!=y. Real memcmp
   would return -1 if x<y, 1 if x>y, and 0 if x==y. */
#define memcpy(x,y,l) (void)FLib_MemCpy((x),(y),(l))

#endif // _TOOLBOX_H_
